#ifndef _CRITICALSECTIONS_H
#define _CRITICALSECTIONS_H

/**
 * \file    OSCriticalSections.h
 * \brief   Wrapper class for CriticalSections functions
 * \detail  .
 * \author  Roberto Waltman, Larry Salant
 * \date    09/02/2008
 * \warning .
 * \note    Should be moved with others to a general purpose utility library
 * \review  .
 **/

class CriticalSection
{
public:
    inline CriticalSection();
    inline ~CriticalSection();
    inline void Enter();
    inline int TryEnter(int timeout);
    inline void Leave();
private:
    UINT32 m_cs;
    //-----------------------------------------------------
    // do not implement
    //-----------------------------------------------------
    CriticalSection(const CriticalSection& cs);
    CriticalSection& operator=(const CriticalSection& cs);
};

inline CriticalSection::CriticalSection()
{
    OsCreateLock(&m_cs);
}

inline void CriticalSection::Enter()
{
  OsLock(m_cs);
}

inline int CriticalSection::TryEnter(int timeout)
{
  return OsLockWait(m_cs, timeout);
}

inline void CriticalSection::Leave()
{
  OsUnlock(m_cs);
}

inline CriticalSection::~CriticalSection()
{
  OsDeleteLock(m_cs);
}


#endif // _CRITICALSECTIONS_H
